function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 302);

T = World_Economy_Cartel_w_inv_shocks.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(265) = T(45)+T(56)+params(30)*y(119)*exp(y(34))*params(6)*params(5)*params(5)*exp(params(5)*y(38));
T(266) = getPowerDeriv(T(9),T(10),3);
T(267) = T(161)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(268) = T(5)*T(267);
T(269) = T(153)+T(152)+exp(y(43))*(T(151)+exp(y(43))*exp(y(43))*getPowerDeriv(exp(y(43)),T(11),3));
T(270) = y(66)*(-(T(89)*T(19)*T(16)*exp(T(1)*y(50))*(1-params(11))*params(3)*T(153)+T(5)*T(19)*T(91)*exp(T(1)*y(50))*(1-params(11))*params(3)*T(153)))+y(65)*(-(T(93)*T(3)*T(16)*exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(153)+T(17)*T(3)*T(91)*exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(153)));
T(271) = y(66)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))*T(153)))+y(65)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))*T(153)));
T(272) = T(164)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(273) = y(66)*(-(T(5)*(T(16)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))*T(164)+T(19)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))*T(90)*T(162))))+y(65)*(-(T(17)*(T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))*T(161)+T(3)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))*T(90)*T(162))));
T(274) = y(66)*(-(T(89)*T(19)*T(61)*T(91)+T(19)*T(16)*T(61)*T(199)+T(89)*T(19)*T(61)*T(91)+T(5)*T(19)*T(61)*T(200)))+y(65)*(-(T(93)*T(3)*T(62)*T(91)+T(17)*T(3)*T(62)*T(200)+T(93)*T(3)*T(62)*T(91)+T(3)*T(16)*T(62)*T(204)));
T(275) = y(66)*(-(T(89)*T(19)*T(16)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))+T(5)*T(19)*T(91)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))))+y(65)*(-(T(17)*T(3)*T(91)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))+T(93)*T(3)*T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))));
T(276) = y(66)*(-(T(5)*T(19)*T(16)*T(60)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))))+y(65)*(-(T(17)*T(3)*T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(277) = getPowerDeriv(T(71),T(10),3);
T(278) = T(158)+exp(y(107))*exp(y(107))*getPowerDeriv(exp(y(107)),T(11),2);
T(279) = (1-params(11))*(1-params(3))*exp(T(1)*y(112))*T(278);
T(280) = T(177)+T(176)+T(20)*(T(175)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(281) = getPowerDeriv(T(67),T(1),3);
T(282) = getPowerDeriv(T(67),T(13),3);
T(283) = T(64)*T(177)*T(64)*T(65)*T(180)+T(77)*T(64)*T(280)+T(64)*T(177)*T(64)*T(65)*T(180)+T(64)*T(65)*(T(64)*T(177)*T(180)+T(64)*T(65)*T(64)*T(65)*T(282));
T(284) = T(64)*T(177)*T(180)*T(66)*T(217)+T(77)*T(177)*T(217)+T(64)*T(65)*T(180)*T(65)*T(217)+T(64)*T(65)*(T(180)*T(65)*T(217)+T(64)*T(65)*T(66)*T(217)*T(282));
T(285) = T(217)+exp(y(108))*exp(y(108))*getPowerDeriv(exp(y(108)),1-params(3),2);
T(286) = T(65)*T(217)*T(180)*T(66)*T(217)+T(77)*T(65)*T(285)+T(65)*T(217)*T(180)*T(66)*T(217)+T(64)*T(65)*(T(66)*T(217)*T(66)*T(217)*T(282)+T(180)*T(66)*T(285));
T(287) = getPowerDeriv(T(6),T(13),3);
T(288) = T(89)*T(161)*T(162)*T(167)+T(90)*T(89)*T(267)+T(89)*T(161)*T(162)*T(167)+T(3)*T(89)*(T(167)*T(268)+T(162)*T(162)*T(287));
T(289) = getPowerDeriv(T(6),T(1),3);
T(290) = getPowerDeriv(T(29),(-params(14)),2);
T(291) = T(187)*(-(params(9)*(T(185)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(186)*T(186)*T(290);
T(292) = T(30)*exp(y(15))*T(187)+T(30)*exp(y(15))*T(187);
T(293) = getPowerDeriv(T(27),(-params(14)),3);
T(294) = T(194)*T(84)*T(195)+T(85)*(-(params(9)*(T(193)+T(192)+T(4)*(T(191)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(194)*T(84)*T(195)+T(84)*(T(194)*T(195)+T(84)*T(84)*T(293));
T(295) = T(199)+T(198)+T(4)*(T(197)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(296) = T(3)*T(199)*T(3)*T(89)*T(167)+T(90)*T(3)*T(295)+T(3)*T(199)*T(3)*T(89)*T(167)+T(3)*T(89)*(T(167)*T(3)*T(199)+T(3)*T(89)*T(3)*T(89)*T(287));
T(297) = getPowerDeriv(T(97),(-params(14)),2);
T(298) = params(1)*(T(223)*(-(params(9)*(T(221)+exp(y(108))*exp(y(108))*getPowerDeriv(exp(y(108)),1+params(8),2))/(1+params(8))))+T(222)*T(222)*T(297));
T(299) = y(66)*(-(T(89)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))+T(5)*T(19)*T(91)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))));
T(300) = y(65)*(-(T(93)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))+T(17)*T(3)*T(91)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(301) = T(230)+exp(y(46))*exp(y(46))*T(195)+exp(y(46))*(exp(y(46))*T(195)+exp(y(46))*exp(y(46))*T(293));
T(302) = getPowerDeriv(T(39),params(5)-1,3);

end
